/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.StringBuilder;

public class BinaryHeap<T extends Node> {
    public int size;
    private Node[] nodes;
    private final boolean isMaxHeap;

    public BinaryHeap() {
        this(16, false);
    }

    public BinaryHeap(int capacity, boolean isMaxHeap) {
        this.isMaxHeap = isMaxHeap;
        this.nodes = new Node[capacity];
    }

    public T add(T node) {
        if (this.size == this.nodes.length) {
            Node[] newNodes = new Node[this.size << 1];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.size);
            this.nodes = newNodes;
        }
        ((Node)node).index = this.size;
        this.nodes[this.size] = node;
        this.up(this.size++);
        return node;
    }

    public T add(T node, float value2) {
        ((Node)node).value = value2;
        return this.add(node);
    }

    public T peek() {
        if (this.size == 0) {
            throw new IllegalStateException("The heap is empty.");
        }
        return (T)this.nodes[0];
    }

    public T pop() {
        return this.remove(0);
    }

    public T remove(T node) {
        return this.remove(((Node)node).index);
    }

    private T remove(int index2) {
        Node[] nodes2 = this.nodes;
        Node removed = nodes2[index2];
        nodes2[index2] = nodes2[--this.size];
        nodes2[this.size] = null;
        if (this.size > 0 && index2 < this.size) {
            this.down(index2);
        }
        return (T)removed;
    }

    public void clear() {
        Node[] nodes2 = this.nodes;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            nodes2[i] = null;
        }
        this.size = 0;
    }

    public void setValue(T node, float value2) {
        float oldValue = ((Node)node).value;
        ((Node)node).value = value2;
        if (value2 < oldValue ^ this.isMaxHeap) {
            this.up(((Node)node).index);
        } else {
            this.down(((Node)node).index);
        }
    }

    private void up(int index2) {
        Node[] nodes2 = this.nodes;
        Node node = nodes2[index2];
        float value2 = node.value;
        while (index2 > 0) {
            int parentIndex = index2 - 1 >> 1;
            Node parent = nodes2[parentIndex];
            if (!(value2 < parent.value ^ this.isMaxHeap)) break;
            nodes2[index2] = parent;
            parent.index = index2;
            index2 = parentIndex;
        }
        nodes2[index2] = node;
        node.index = index2;
    }

    private void down(int index2) {
        int leftIndex;
        Node[] nodes2 = this.nodes;
        int size2 = this.size;
        Node node = nodes2[index2];
        float value2 = node.value;
        while ((leftIndex = 1 + (index2 << 1)) < size2) {
            float rightValue;
            Node rightNode;
            int rightIndex = leftIndex + 1;
            Node leftNode = nodes2[leftIndex];
            float leftValue = leftNode.value;
            if (rightIndex >= size2) {
                rightNode = null;
                rightValue = this.isMaxHeap ? Float.MIN_VALUE : Float.MAX_VALUE;
            } else {
                rightNode = nodes2[rightIndex];
                rightValue = rightNode.value;
            }
            if (leftValue < rightValue ^ this.isMaxHeap) {
                if (leftValue == value2 || leftValue > value2 ^ this.isMaxHeap) break;
                nodes2[index2] = leftNode;
                leftNode.index = index2;
                index2 = leftIndex;
                continue;
            }
            if (rightValue == value2 || rightValue > value2 ^ this.isMaxHeap) break;
            nodes2[index2] = rightNode;
            rightNode.index = index2;
            index2 = rightIndex;
        }
        nodes2[index2] = node;
        node.index = index2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BinaryHeap)) {
            return false;
        }
        BinaryHeap other = (BinaryHeap)obj;
        if (other.size != this.size) {
            return false;
        }
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (other.nodes[i].value == this.nodes[i].value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h = h * 31 + Float.floatToIntBits(this.nodes[i].value);
        }
        return h;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        Node[] nodes2 = this.nodes;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(nodes2[0].value);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(nodes2[i].value);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static class Node {
        float value;
        int index;

        public Node(float value2) {
            this.value = value2;
        }

        public float getValue() {
            return this.value;
        }

        public String toString() {
            return Float.toString(this.value);
        }
    }
}

